package com.swvoitures.reservation;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

import java.util.Random;

/*
* La classe <code>Reservation</code> gre les informations 
* d'une rservation prise en charge par le systme de rservation 
* de la centrale de rservation.
*
* @version  1.0
*/
public class Reservation {
	
	private final static Random idGenerator = new Random();

	private int id = 0;

	private int passengers = 0;
	private String from = "";
	private String to = "";
	private boolean roundTrip = false;
	private int departureDay = 0;
	private int departureMonth = 0;
	private int departureYear = 0;
	private int arrivalDay = 0;
	private int arrivalMonth = 0;
	private int arrivalYear = 0;

	private int remoteId = 0;

	private CarAvailability[] carAvailabilities;
	
	private Writer writer;

	/*
	* Le constructeur de rservation.
	*/
	public Reservation() {
		getId();
		try {
			writer = new BufferedWriter(new OutputStreamWriter(System.out, "Cp850"));
		}
		catch(UnsupportedEncodingException e) {
			writer = new BufferedWriter(new OutputStreamWriter(System.out));
		}
	}

	/*
	* Renvoie l'identifiant de la rservation.
	*/
	public synchronized int getId() {
		if (id == 0) {
			id = idGenerator.nextInt();
		}
		return id;
	}

	/*
	* Renvoie l'identifiant de la rservation
	* du partenaire de rservation.
	*/
	public int getRemoteId() {
		return remoteId;
	}

	/*
	* Affecte l'identifiant de la rservation
	* du partenaire de rservation.
	*
	* @param		remoteId l'identifiant de la rservation
	*				du partenaire de rservation
	*/
	public void setRemoteId(int remoteId) {
		this.remoteId = remoteId;
	}

	/*
	* Affiche dans la log du serveur le statut de la
	* rservation effectue par l'utilisateur.
	*
	* @param		availabilityId l'identifiant de la
	*				disponibilit si la rservation a
	*				t confirme; 0 sinon
	*/
	public void status(int availabilityId)
		throws ReservationException {

		StringBuffer sb = new StringBuffer();
		sb.append("\nrservation ");
		if (availabilityId!=0) {
			sb.append("confirme");
		}
		else {
			sb.append("annule");
		}
		sb.append(" par SW-Voitures");
		sb.append("\n localit de dpart : ");
		sb.append(getFrom());
		sb.append("\n localit d'arrive : ");
		sb.append(getTo());
		sb.append("\n date de dpart : ");
		sb.append(getDepartureDay());
		sb.append("-");
		sb.append(getDepartureMonth());
		sb.append("-");
		sb.append(getDepartureYear());
		sb.append("\n voyage : ");
		if (getRoundTrip()) {
			sb.append("aller retour");
			sb.append("\n date de retour : ");
			sb.append(getArrivalDay());
			sb.append("-");
			sb.append(getArrivalMonth());
			sb.append("-");
			sb.append(getArrivalYear());
		}
		else {
			sb.append("aller simple");
		}
		sb.append("\n voyageurs : ");
		sb.append(getPassengers());
		sb.append("\n");
		try {
			writer.write(sb.toString());
			writer.flush();
		}
		catch(IOException e) {
			System.out.println(sb);
		}
		
		if (availabilityId!=0) {
			CarAvailability availability = getAvailability(availabilityId);
			availability.status();
		}
	}

	/*
	* Renvoie la disponibilit de SW-Voitures dont l'identifiant 
	* est pass en paramtre.
	*/
	private CarAvailability getAvailability(int availabilityId)
		throws ReservationException {

		CarAvailability[] availabilities = getCarAvailabilities();
		for(int i=0; i<availabilities.length; i++) {
			CarAvailability availability = availabilities[i];
			if (availability.getId()==availabilityId) {
				return availabilities[i];
			}
		}
		throw new ReservationException("disponibilit non trouve");
	}

	/*
	* Renvoie les disponibilits de SW-Voitures associes  
	* cette rservation.
	*/
	public synchronized CarAvailability[] getCarAvailabilities() {
		if (carAvailabilities!=null) {
			return carAvailabilities;
		}

		if (!to.equalsIgnoreCase("Vienne")) {
			return new CarAvailability[]{};
		}

		carAvailabilities = new CarAvailability[4];
		CarAvailability carAvailability1 = new CarAvailability();
		carAvailability1.setCarRentalCompany("SW Austria Renters");
		carAvailability1.setCarCategory("A");
		carAvailability1.setCarModel("SW Motors Classica 3 portes");
		carAvailability1.setPricePerWeek(240);
		carAvailability1.setPricePerDay(34);
		carAvailabilities[0] = carAvailability1;
		CarAvailability carAvailability2 = new CarAvailability();
		carAvailability2.setCarRentalCompany("SW Austria Renters");
		carAvailability2.setCarCategory("B");
		carAvailability2.setCarModel("SW Motors Cygna 3 portes");
		carAvailability2.setPricePerWeek(263);
		carAvailability2.setPricePerDay(37);
		carAvailabilities[1] = carAvailability2;
		CarAvailability carAvailability3 = new CarAvailability();
		carAvailability3.setCarRentalCompany("SW Wien Cars");
		carAvailability3.setCarCategory("C");
		carAvailability3.setCarModel("SW Drivers 3200 5 Portes");
		carAvailability3.setPricePerWeek(280);
		carAvailability3.setPricePerDay(40);
		carAvailabilities[2] = carAvailability3;
		CarAvailability carAvailability4 = new CarAvailability();
		carAvailability4.setCarRentalCompany("SW Wien Cars");
		carAvailability4.setCarCategory("D");
		carAvailability4.setCarModel("SW Motors Carla 5 portes");
		carAvailability4.setPricePerWeek(337);
		carAvailability4.setPricePerDay(48);
		carAvailabilities[3] = carAvailability4;
		return carAvailabilities;
	}

	/*
	* Affecte les disponibilits de SW-Voitures associes
	*  cette rservation.
	*
	* @param		carAvailabilities les disponibilits
	*				de SW-Voitures
	*/
	public void setCarAvailabilities(CarAvailability[] carAvailabilities) {
		this.carAvailabilities = carAvailabilities;
	}

	/*
	* Renvoie le nombre de voyageurs.
	*
	* @return		int le nombre de voyageurs
	*/
	public int getPassengers() {
		return this.passengers;
	}

	/*
	* Affecte le nombre de voyageurs.
	*
	* @param		passengers le nombre de voyageurs
	*/
	public void setPassengers(int passengers) {
		this.passengers = passengers;
	}

	/*
	* Renvoie la localit de dpart.
	*
	* @return		String la localit de dpart
	*/
	public String getFrom() {
		return this.from;
	}

	/*
	* Affecte la localit de dpart.
	*
	* @param		from la localit de dpart
	*/
	public void setFrom(String from) {
		this.from = from;
	}

	/*
	* Renvoie la localit d'arrive.
	*
	* @return		String la localit d'arrive
	*/
	public String getTo() {
		return this.to;
	}

	/*
	* Affecte la localit d'arrive.
	*
	* @param		from la localit d'arrive
	*/
	public void setTo(String to) {
		this.to = to;
	}

	/*
	* Renvoie le voyage.
	*
	* @return		boolean le voyage
	*/
	public boolean getRoundTrip() {
		return this.roundTrip;
	}

	/*
	* Affecte le voyage.
	*
	* @param		roundTrip le voyage
	*/
	public void setRoundTrip(boolean roundTrip) {
		this.roundTrip = roundTrip;
	}

	/*
	* Renvoie le jour de dpart.
	*
	* @return		int le jour de dpart
	*/
	public int getDepartureDay() {
		return this.departureDay;
	}

	/*
	* Affecte le jour de dpart.
	*
	* @param		departureDay le jour de dpart
	*/
	public void setDepartureDay(int departureDay) {
		this.departureDay = departureDay;
	}

	/*
	* Renvoie le mois de dpart.
	*
	* @return		int le mois de dpart
	*/
	public int getDepartureMonth() {
		return this.departureMonth;
	}

	/*
	* Affecte le mois de dpart.
	*
	* @param		departureMonth le mois de dpart
	*/
	public void setDepartureMonth(int departureMonth) {
		this.departureMonth = departureMonth;
	}

	/*
	* Renvoie l'anne de dpart.
	*
	* @return		int l'anne de dpart
	*/
	public int getDepartureYear() {
		return this.departureYear;
	}

	/*
	* Affecte l'anne de dpart.
	*
	* @param		departureYear l'anne de dpart
	*/
	public void setDepartureYear(int departureYear) {
		this.departureYear = departureYear;
	}

	/*
	* Renvoie le jour de retour.
	*
	* @return		int le jour de retour
	*/
	public int getArrivalDay() {
		return this.arrivalDay;
	}

	/*
	* Affecte le jour de retour.
	*
	* @param		arrivalDay le jour de retour
	*/
	public void setArrivalDay(int arrivalDay) {
		this.arrivalDay = arrivalDay;
	}

	/*
	* Renvoie le mois de retour.
	*
	* @return		int le mois de retour
	*/
	public int getArrivalMonth() {
		return this.arrivalMonth;
	}

	/*
	* Affecte le mois de retour.
	*
	* @param		arrivalMonth le mois de retour
	*/
	public void setArrivalMonth(int arrivalMonth) {
		this.arrivalMonth = arrivalMonth;
	}

	/*
	* Renvoie l'anne de retour.
	*
	* @return		int l'anne de retour
	*/
	public int getArrivalYear() {
		return this.arrivalYear;
	}

	/*
	* Affecte l'anne de retour.
	*
	* @param		arrivalYear l'anne de retour
	*/
	public void setArrivalYear(int arrivalYear) {
		this.arrivalYear = arrivalYear;
	}

	/*
	* Renvoie une reprsentation textuelle de la
	* rservation. 
	*
	* @return		une reprsentation textuelle de la
	* 				rservation.
	*/
	public String toString() {
		StringBuffer sb = new StringBuffer();
		sb.append("\n");
		sb.append(getClass().getName());
		sb.append("@");
		sb.append(Integer.toHexString(hashCode()));
		return sb.toString();
	}
}